#ifdef GL_ES
precision mediump float;

varying vec3 normal, light, halfVector;
varying float dist;
varying float location;

vec4 fragColor;
#else
in vec3 normal, light, halfVector;
in float dist;
in float location;

out vec4 fragColor;
#endif
uniform vec4 darkColor;
uniform vec4 lightColor;
uniform float percentage;

void main()
{
	float diffuse, specular;
	
	diffuse = max(dot(normal, light), 0.0);
	specular = dot(normal, halfVector) * dist;
	
	vec4 chosenColor = mix(darkColor, lightColor, step(location, percentage));
	chosenColor.rgb = chosenColor.rgb + chosenColor.rgb * chosenColor.rgb * chosenColor.a;
	vec3 ambient = chosenColor.rgb * chosenColor.a * 0.5;
	fragColor = vec4(ambient + (diffuse + specular) * chosenColor.rgb, 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
